package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTipoBoletin;
import com.ejie.ab18a.utils.Utilidades;

/**
 * Ab18a06s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aTipoBoletinDaoImpl implements Ab18aTipoBoletinDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aTipoBoletin> rwMap = new RowMapper<Ab18aTipoBoletin>() {
		public Ab18aTipoBoletin mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aTipoBoletin(resultSet.getLong("T06IDBOLETIN"), resultSet.getString("T06DESC"), resultSet.getString("T06LOGIN"),
					resultSet.getString("T06PASS"), resultSet.getDate("T06FECHAULTMODIF"));
		}
	};

	private RowMapper<Ab18aTipoBoletin> rwMapPK = new RowMapper<Ab18aTipoBoletin>() {
		public Ab18aTipoBoletin mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aTipoBoletin(resultSet.getLong("T06IDBOLETIN"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aTipoBoletin>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aTipoBoletin>>() {
		public JerarquiaDto<Ab18aTipoBoletin> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aTipoBoletin ab18a06s00 = new Ab18aTipoBoletin(resultSet.getLong("T06IDBOLETIN"), resultSet.getString("T06DESC"),
					resultSet.getString("T06LOGIN"), resultSet.getString("T06PASS"), resultSet.getDate("T06FECHAULTMODIF"));

			JerarquiaDto<Ab18aTipoBoletin> jerarquia = new JerarquiaDto<Ab18aTipoBoletin>();
			jerarquia.setModel(ab18a06s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 * @throws Exception
	 * @throws DataAccessException
	 */
	public Ab18aTipoBoletin add(Ab18aTipoBoletin ab18a06s00) throws DataAccessException, Exception {
		String query = "INSERT INTO AB18A06S00 (T06_ID_BOLETIN, T06_DESC, T06_LOGIN, T06_PASS, T06_FECHA_ULT_MODIF) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, this.getNextSequenceValue("SQAB18A06"), ab18a06s00.getT06Desc(), ab18a06s00.getT06Login(),
				ab18a06s00.getT06Pass(), ab18a06s00.getT06FechaUltModif());
		return ab18a06s00;
	}

	/**
	 * Updates a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 */
	public Ab18aTipoBoletin update(Ab18aTipoBoletin ab18a06s00) {
		String query = "UPDATE AB18A06S00 SET T06_DESC=?, T06_LOGIN=?, T06_PASS=?, T06_FECHA_ULT_MODIF = CURRENT_TIMESTAMP WHERE T06_ID_BOLETIN=?";
		this.jdbcTemplate.update(query, ab18a06s00.getT06Desc(), ab18a06s00.getT06Login(), ab18a06s00.getT06Pass(), ab18a06s00.getT06IdBoletin());
		return ab18a06s00;
	}

	/**
	 * Finds a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Ab18a06s00
	 */
	@Transactional(readOnly = true)
	public Ab18aTipoBoletin find(Ab18aTipoBoletin ab18a06s00) {
		String query = "SELECT t1.T06_ID_BOLETIN T06IDBOLETIN, t1.T06_DESC T06DESC, t1.T06_LOGIN T06LOGIN, t1.T06_PASS T06PASS, t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF FROM AB18A06S00 t1  WHERE t1.T06_ID_BOLETIN = ?  ";

		List<Ab18aTipoBoletin> ab18a06s00List = this.jdbcTemplate.query(query, this.rwMap, ab18a06s00.getT06IdBoletin());
		return (Ab18aTipoBoletin) DataAccessUtils.uniqueResult(ab18a06s00List);
	}

	/**
	 * Finds a single row in the Ab18a06s00 table by desc.
	 * 
	 * @param tipoBoletin
	 *            Ab18aTipoBoletin
	 * @return Ab18aTipoBoletin
	 */
	@Transactional(readOnly = true)
	public Ab18aTipoBoletin findByDesc(Ab18aTipoBoletin tipoBoletin) {
		String query = "SELECT t1.T06_ID_BOLETIN T06IDBOLETIN, t1.T06_DESC T06DESC, t1.T06_LOGIN T06LOGIN, t1.T06_PASS T06PASS, t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF FROM AB18A06S00 t1  WHERE t1.T06_DESC = ?  ";

		List<Ab18aTipoBoletin> tipoBoletinList = this.jdbcTemplate.query(query, this.rwMap, tipoBoletin.getT06Desc());
		return (Ab18aTipoBoletin) DataAccessUtils.uniqueResult(tipoBoletinList);
	}

	/**
	 * Removes a single row in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return
	 */
	public void remove(Ab18aTipoBoletin ab18a06s00) {
		String query = "DELETE FROM AB18A06S00 WHERE T06_ID_BOLETIN=?";
		this.jdbcTemplate.update(query, ab18a06s00.getT06IdBoletin());
	}

	/**
	 * Finds a list of rows in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a06s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTipoBoletin> findAll(Ab18aTipoBoletin ab18a06s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		query.append("FROM AB18A06S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a06s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTipoBoletin>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a06s00 table using like.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a06s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTipoBoletin> findAllLike(Ab18aTipoBoletin ab18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		query.append("FROM AB18A06S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a06s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTipoBoletin>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aTipoBoletin ab18a06s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A06S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a06s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a06s00 table using like.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aTipoBoletin ab18a06s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A06S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a06s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a06s00 selected for rup_table
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a06s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoBoletin>> reorderSelection(Ab18aTipoBoletin ab18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A06S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a06s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aTipoBoletin.class, filterParamList,
				"T06_ID_BOLETIN");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aTipoBoletin>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a06s00
	 * @param searchParams
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a06s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoBoletin>> search(Ab18aTipoBoletin filterParams, Ab18aTipoBoletin searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A06S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aTipoBoletin.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T06_ID_BOLETIN");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aTipoBoletin>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aTipoBoletin filterab18a06s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		// FROM
		query.append("FROM AB18A06S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a06s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aTipoBoletin.class, query, params,
				"T06_ID_BOLETIN");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a06s00 table.
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a06s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aTipoBoletin>> findAllLikeJerarquia(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T06_ID_BOLETIN T06IDBOLETIN,t1.T06_DESC T06DESC,t1.T06_LOGIN T06LOGIN,t1.T06_PASS T06PASS,t1.T06_FECHA_ULT_MODIF T06FECHAULTMODIF ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A06S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A06S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a06s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T06_ID_BOLETIN", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A06S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a06s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T06_ID_BOLETIN", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a06s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoBoletin>> findAllChild(Ab18aTipoBoletin filterAb18a06s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A06S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A06S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a06s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T06_ID_BOLETIN", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aTipoBoletin>(this.rwMapPK, "T06_ID_BOLETIN"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a06s00 entity
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aTipoBoletin ab18a06s00) {

		StringBuilder where = new StringBuilder(Ab18aTipoBoletinDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a06s00 != null && ab18a06s00.getT06IdBoletin() != null) {
			where.append(" AND t1.T06_ID_BOLETIN = ?");
			params.add(ab18a06s00.getT06IdBoletin());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a06s00.getT06Desc())) {
			where.append(" AND t1.T06_DESC = ?");
			params.add(ab18a06s00.getT06Desc());
		}
		if (ab18a06s00 != null && ab18a06s00.getT06Login() != null) {
			where.append(" AND t1.T06_LOGIN = ?");
			params.add(ab18a06s00.getT06Login());
		}
		if (ab18a06s00 != null && ab18a06s00.getT06Pass() != null) {
			where.append(" AND t1.T06_PASS = ?");
			params.add(ab18a06s00.getT06Pass());
		}
		if (ab18a06s00 != null && ab18a06s00.getT06FechaUltModif() != null) {
			where.append(" AND t1.T06_FECHA_ULT_MODIF = ?");
			params.add(ab18a06s00.getT06FechaUltModif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a06s00 entity
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aTipoBoletin ab18a06s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aTipoBoletinDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a06s00 != null && Utilidades.notNullAndNotEmpty(ab18a06s00.getT06IdBoletin())) {
			where.append(" AND t1.T06_ID_BOLETIN = ?");
			params.add(ab18a06s00.getT06IdBoletin());
		}
		if (ab18a06s00 != null && Utilidades.notNullAndNotEmpty(ab18a06s00.getT06Desc())) {
			where.append(" AND UPPER(t1.T06_DESC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a06s00.getT06Desc().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(ab18a06s00.getT06Desc().toUpperCase()) + "%");
			}
			where.append(" AND t1.T06_DESC IS NOT NULL");
		}
		if (ab18a06s00 != null && Utilidades.notNullAndNotEmpty(ab18a06s00.getT06Login())) {
			where.append(" AND UPPER(t1.T06_LOGIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a06s00.getT06Login().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a06s00.getT06Login().toUpperCase() + "%");
			}
			where.append(" AND t1.T06_LOGIN IS NOT NULL");
		}
		if (ab18a06s00 != null && Utilidades.notNullAndNotEmpty(ab18a06s00.getT06Pass())) {
			where.append(" AND UPPER(t1.T06_PASS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a06s00.getT06Pass().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a06s00.getT06Pass().toUpperCase() + "%");
			}
			where.append(" AND t1.T06_PASS IS NOT NULL");
		}
		if (ab18a06s00 != null && Utilidades.notNullAndNotEmpty(ab18a06s00.getT06FechaUltModif())) {
			where.append(" AND t1.T06_FECHA_ULT_MODIF = ?");
			params.add(ab18a06s00.getT06FechaUltModif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}
}
